using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Drawing.Imaging;
using System.Runtime.InteropServices;
using System.Windows.Forms;
using System.Data;
using VCamCOMLib;

namespace VCamCOMTestCSharp
{
	/// <summary>
	/// Summary description for MainForm.
	/// </summary>
	public class MainForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Button btnPlayFile;
		private System.Windows.Forms.Button btnPlayBuffer;
		private System.Windows.Forms.Button btnStop;
		private System.Windows.Forms.Button btnQuit;
		private System.Windows.Forms.LinkLabel linkLabelHome;
		private System.Windows.Forms.Button btnSeek;
		private System.Windows.Forms.Button btnPlayDevice;
		private System.Windows.Forms.Button btnCapture;
		private System.Windows.Forms.Button btnConfig;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
        private Button btnOverlay;
        private Button btnCaptureFixed;

		private VCamSDK vcam = new VCamSDK();

		public MainForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.linkLabelHome = new System.Windows.Forms.LinkLabel();
            this.btnPlayFile = new System.Windows.Forms.Button();
            this.btnPlayBuffer = new System.Windows.Forms.Button();
            this.btnStop = new System.Windows.Forms.Button();
            this.btnQuit = new System.Windows.Forms.Button();
            this.btnSeek = new System.Windows.Forms.Button();
            this.btnPlayDevice = new System.Windows.Forms.Button();
            this.btnCapture = new System.Windows.Forms.Button();
            this.btnConfig = new System.Windows.Forms.Button();
            this.btnOverlay = new System.Windows.Forms.Button();
            this.btnCaptureFixed = new System.Windows.Forms.Button();
            this.SuspendLayout();
            // 
            // linkLabelHome
            // 
            this.linkLabelHome.Location = new System.Drawing.Point(19, 365);
            this.linkLabelHome.Name = "linkLabelHome";
            this.linkLabelHome.Size = new System.Drawing.Size(115, 17);
            this.linkLabelHome.TabIndex = 0;
            this.linkLabelHome.TabStop = true;
            this.linkLabelHome.Text = "www.e2esoft.cn";
            // 
            // btnPlayFile
            // 
            this.btnPlayFile.Location = new System.Drawing.Point(48, 34);
            this.btnPlayFile.Name = "btnPlayFile";
            this.btnPlayFile.Size = new System.Drawing.Size(259, 25);
            this.btnPlayFile.TabIndex = 1;
            this.btnPlayFile.Text = "Play a video file";
            this.btnPlayFile.Click += new System.EventHandler(this.btnPlayFile_Click);
            // 
            // btnPlayBuffer
            // 
            this.btnPlayBuffer.Location = new System.Drawing.Point(48, 213);
            this.btnPlayBuffer.Name = "btnPlayBuffer";
            this.btnPlayBuffer.Size = new System.Drawing.Size(259, 25);
            this.btnPlayBuffer.TabIndex = 1;
            this.btnPlayBuffer.Text = "Send a buffer to driver";
            this.btnPlayBuffer.Click += new System.EventHandler(this.btnPlayBuffer_Click);
            // 
            // btnStop
            // 
            this.btnStop.Location = new System.Drawing.Point(48, 284);
            this.btnStop.Name = "btnStop";
            this.btnStop.Size = new System.Drawing.Size(259, 24);
            this.btnStop.TabIndex = 1;
            this.btnStop.Text = "Stop play";
            this.btnStop.Click += new System.EventHandler(this.btnStop_Click);
            // 
            // btnQuit
            // 
            this.btnQuit.Location = new System.Drawing.Point(240, 365);
            this.btnQuit.Name = "btnQuit";
            this.btnQuit.Size = new System.Drawing.Size(96, 25);
            this.btnQuit.TabIndex = 1;
            this.btnQuit.Text = "Quit";
            this.btnQuit.Click += new System.EventHandler(this.btnQuit_Click);
            // 
            // btnSeek
            // 
            this.btnSeek.Location = new System.Drawing.Point(48, 70);
            this.btnSeek.Name = "btnSeek";
            this.btnSeek.Size = new System.Drawing.Size(259, 25);
            this.btnSeek.TabIndex = 1;
            this.btnSeek.Text = "Seek to 30th seconds of current video";
            this.btnSeek.Click += new System.EventHandler(this.btnSeek_Click);
            // 
            // btnPlayDevice
            // 
            this.btnPlayDevice.Location = new System.Drawing.Point(48, 106);
            this.btnPlayDevice.Name = "btnPlayDevice";
            this.btnPlayDevice.Size = new System.Drawing.Size(259, 24);
            this.btnPlayDevice.TabIndex = 1;
            this.btnPlayDevice.Text = "Play a video device";
            this.btnPlayDevice.Click += new System.EventHandler(this.btnPlayDevice_Click);
            // 
            // btnCapture
            // 
            this.btnCapture.Location = new System.Drawing.Point(48, 141);
            this.btnCapture.Name = "btnCapture";
            this.btnCapture.Size = new System.Drawing.Size(259, 25);
            this.btnCapture.TabIndex = 1;
            this.btnCapture.Text = "Screen Capture";
            this.btnCapture.Click += new System.EventHandler(this.btnCapture_Click);
            // 
            // btnConfig
            // 
            this.btnConfig.Location = new System.Drawing.Point(48, 319);
            this.btnConfig.Name = "btnConfig";
            this.btnConfig.Size = new System.Drawing.Size(259, 25);
            this.btnConfig.TabIndex = 1;
            this.btnConfig.Text = "Set parameters of driver";
            this.btnConfig.Click += new System.EventHandler(this.btnConfig_Click);
            // 
            // btnOverlay
            // 
            this.btnOverlay.Location = new System.Drawing.Point(48, 249);
            this.btnOverlay.Name = "btnOverlay";
            this.btnOverlay.Size = new System.Drawing.Size(259, 24);
            this.btnOverlay.TabIndex = 1;
            this.btnOverlay.Text = "Add overlay";
            this.btnOverlay.Click += new System.EventHandler(this.btnOverlay_Click);
            // 
            // btnCaptureFixed
            // 
            this.btnCaptureFixed.Location = new System.Drawing.Point(48, 177);
            this.btnCaptureFixed.Name = "btnCaptureFixed";
            this.btnCaptureFixed.Size = new System.Drawing.Size(259, 25);
            this.btnCaptureFixed.TabIndex = 1;
            this.btnCaptureFixed.Text = "Screen Capture (fixed)";
            this.btnCaptureFixed.Click += new System.EventHandler(this.btnCaptureFixed_Click);
            // 
            // MainForm
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(6, 14);
            this.ClientSize = new System.Drawing.Size(354, 398);
            this.Controls.Add(this.btnPlayFile);
            this.Controls.Add(this.linkLabelHome);
            this.Controls.Add(this.btnPlayBuffer);
            this.Controls.Add(this.btnOverlay);
            this.Controls.Add(this.btnStop);
            this.Controls.Add(this.btnQuit);
            this.Controls.Add(this.btnSeek);
            this.Controls.Add(this.btnPlayDevice);
            this.Controls.Add(this.btnCaptureFixed);
            this.Controls.Add(this.btnCapture);
            this.Controls.Add(this.btnConfig);
            this.Name = "MainForm";
            this.Text = "VCamCOM C# test application";
            this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new MainForm());
		}

		private void btnQuit_Click(object sender, System.EventArgs e)
		{
			Application.Exit();
		}

		private void btnPlayFile_Click(object sender, System.EventArgs e)
		{	
			btnStop_Click(sender, e);

			OpenFileDialog ofd = new OpenFileDialog();

			if (ofd.ShowDialog() == DialogResult.OK)
			{
				vcam.PlayVideoFile(ofd.FileName);
			}			
		}

		private void btnSeek_Click(object sender, System.EventArgs e)
		{
			vcam.CurrentVideoPosition = 30 * 1000;
		}

		private void btnPlayDevice_Click(object sender, System.EventArgs e)
		{
			btnStop_Click(sender, e);

			int no = 0;

			if (DialogResult.Yes == MessageBox.Show("Choose [Yes] if VCam is your first Video Capture Device,\n\rChoose [No] if not.\n\n\rNote: You must have one Video Capture Device to use this feature.",
				"Question", MessageBoxButtons.YesNo, MessageBoxIcon.Question)) {
				no = 1;
			}

			vcam.PlayVideoDevice(no); // if #1 is e2eCam, change it to #0, or #2...
		}

		private void btnCapture_Click(object sender, System.EventArgs e)
		{
			btnStop_Click(sender, e);

			vcam.CaptureScreen();
		}

        private void btnCaptureFixed_Click(object sender, EventArgs e)
        {
            btnStop_Click(sender, e);

            vcam.CaptureScreenFixed(100, 100, 320, 240);
        }

		private void btnPlayBuffer_Click(object sender, System.EventArgs e)
		{
			btnStop_Click(sender, e);

			byte[] buffer = new byte [320*240*3];
			Random rdm = new Random();
			for (int i=0; i<320*240*3; i++) 
			{
				buffer[i] = (byte)rdm.Next(255);
			}
			vcam.PlayBufferEx(buffer, 320, 240);
		}

        private void btnOverlay_Click(object sender, EventArgs e)
        {
            var png = new Bitmap("star.png");
            var rc = new Rectangle(0, 0, png.Width, png.Height);
		    var bd = new BitmapData();
		    png.LockBits(rc, ImageLockMode.ReadOnly, PixelFormat.Format32bppArgb, bd);
            var buffer = new byte[png.Width*png.Height*4];
            Marshal.Copy(bd.Scan0, buffer, 0, png.Width * png.Height * 4);
            // RGBA -> ARGB
            for (int i = 0; i < bd.Height; i++)
            {
                for (int j = 0; j < bd.Width; j++)
                {
                    byte a, r, g, b;
                    r = buffer[i * bd.Stride + j * 4 + 0];
                    g = buffer[i * bd.Stride + j * 4 + 1];
                    b = buffer[i * bd.Stride + j * 4 + 2];
                    a = buffer[i * bd.Stride + j * 4 + 3];

                    buffer[i * bd.Stride + j * 4 + 0] = a;
                    buffer[i * bd.Stride + j * 4 + 1] = r;
                    buffer[i * bd.Stride + j * 4 + 2] = g;
                    buffer[i * bd.Stride + j * 4 + 3] = b;
                }
            }
            vcam.AddOverlay(buffer, (uint)png.Width, (uint)png.Height, 280, 10, 0);
            png.UnlockBits(bd);

            vcam.AddText("This is text one", "Comic Sans MS", -20, 0, 0x0000FF, 0x00FF00, 75, 80, 1, 0);
            // vcam.AddText(null, null, 0, 0, 0, 0, 0, 0, 0, 0); // remove it
            vcam.AddText("This is text two", "Comic Sans MS", -16, 0, 0xFF0000, 0x00FFFF, 75, 110, 2, 1);
            vcam.AddText("This is text three", "Comic Sans MS", -16, 0, 0xFF0000, 0x00FFFF, 75, 140, 0, 2);
        }

		private void btnStop_Click(object sender, System.EventArgs e)
		{
			vcam.StopPlay();
			vcam.StopCaptureScreen();
		}

		private void btnConfig_Click(object sender, System.EventArgs e)
		{
            // Important: make sure that no application are using VCam while calling these methods!

			vcam.ChangeDefaultVideoSize(640, 480); // 640 x 480 (2 means 320 x 240)
			vcam.ChangeDefaultFPS(10);
			MessageBox.Show("VCam's default frame rate is set to 10, and video size is changed to 640 x 480.", 
                "Make sure no application is using VCam!");

            vcam.SetLicenseCode("123456");
		}
	}
}
