#pragma once
#include <streams.h>
#pragma warning(disable:4995)
#include <comdef.h>

class IVCamSource;
class IVCamRenderer;

// smart ptrs
_COM_SMARTPTR_TYPEDEF(IFilterGraph,		IID_IFilterGraph);
_COM_SMARTPTR_TYPEDEF(IGraphBuilder,	IID_IGraphBuilder);
_COM_SMARTPTR_TYPEDEF(IBaseFilter,		IID_IBaseFilter);
_COM_SMARTPTR_TYPEDEF(IMediaEvent,		IID_IMediaEvent);
_COM_SMARTPTR_TYPEDEF(IMediaControl,	IID_IMediaControl);
_COM_SMARTPTR_TYPEDEF(IMediaSeeking ,	IID_IMediaSeeking);

class CVCamSDKImpl
{
public:
	CVCamSDKImpl(void);
	~CVCamSDKImpl(void);

	void	SetVCamDeviceName(BSTR pDevName);
	void	SetProp(ULONG lIndex, long lValue);

	void	SetLicenseCode(BSTR pRegStr);

	HRESULT PlayVideoFile(LPCTSTR fileName);
	LONG	GetCurrentVideoDuration(); // ms as UNIT
	LONG	GetCurrentVideoPosition();
	HRESULT	SetCurrentVideoPosition(LONG pos);

	HRESULT PlayVideoDevice(UINT idx);

	bool	IsPlaying();
	void	StopPlay();

	void	CaptureScreen();	
	void	CaptureScreen(RECT rcZone);
	void	StopCapture();
	
	void	PlayBuffer(PBYTE rgb24Buffer, DWORD dwWidth, DWORD dwHeight);

	void	AddOverlay(BYTE *pRgb32Buffer, long width, long height, long px, long py, long whichOne = 0);
	void	AddText(BSTR olText, BSTR ftName, LONG ftSize, LONG ftStyle, LONG ftColor, LONG bkColor, LONG px, LONG py, LONG bkType, LONG whichOne = 0);	

public:
	friend DWORD WINAPI GraphCheckThread(LPVOID lpParam);

protected:
	IGraphBuilderPtr		m_pGraph;
	IMediaSeekingPtr		m_pMS;
	IMediaControlPtr		m_pMC;
	IBaseFilterPtr			m_pVCamRenderer;
	IVCamSource*			m_pIVCamSource;
	IVCamRenderer*			m_pIVCamRenderer;

	HANDLE					m_hGraphCheckThread;
	BOOL					m_bStopGraphCheck;
};

// HOWTO: Change VCam name ->
// [HKEY_LOCAL_MACHINE\SOFTWARE\Classes\CLSID\{860BB310-5D01-11d0-BD3B-00A0C911CE86}\Instance\e2eSoft VCam]
// "FriendlyName"="e2eSoft VCam"