// MainDlg.h : interface of the CMainDlg class
//
/////////////////////////////////////////////////////////////////////////////

#pragma once

#include "WndThumbnail.h"
#include "Player.h"

class CMainDlg : public CDialogImpl<CMainDlg>
{
public:
	enum { IDD = IDD_MAINDLG };
	
	CMainDlg()
		: m_ImageC(0)
		, m_SelectedEffect(-1)
		, m_ThumbnailSize(0)
		, m_ThumbnailBits(0)
		, m_Effect(0)
		, m_Transition(0)
		, m_EffectType(CEffectPlayer::EFFECT_TRANSITION)
	{
		m_Impl = this;
	}

	~CMainDlg()
	{
		if (m_ThumbnailBits) delete [] m_ThumbnailBits, m_ThumbnailBits = 0;
	}

	BEGIN_MSG_MAP(CMainDlg)
		MESSAGE_HANDLER(WM_INITDIALOG,						OnInitDialog)
		MESSAGE_HANDLER(WM_DESTROY,							OnDestory)
		MESSAGE_HANDLER(WM_HSCROLL,							OnHScroll)
		COMMAND_ID_HANDLER(ID_APP_ABOUT,					OnAppAbout)
		COMMAND_ID_HANDLER(IDOK,							OnOK)
		COMMAND_ID_HANDLER(IDCANCEL,						OnCancel)
		COMMAND_HANDLER(IDC_LIST_EFFECTS, LBN_SELCHANGE,	OnEffectChangled)
		COMMAND_HANDLER(IDC_BUTTON_PLAY,		BN_CLICKED, OnBnClickedButtonPlay)
		COMMAND_HANDLER(IDC_BUTTON_PAUSE,		BN_CLICKED, OnBnClickedButtonPause)
		COMMAND_HANDLER(IDC_RADIO_EFFECT,		BN_CLICKED, OnBnClickedEffect)
		COMMAND_HANDLER(IDC_RADIO_TRANSITION,	BN_CLICKED, OnBnClickedTransition)
	END_MSG_MAP()

// Handler prototypes (uncomment arguments if needed):
//	LRESULT MessageHandler(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/)
//	LRESULT CommandHandler(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
//	LRESULT NotifyHandler(int /*idCtrl*/, LPNMHDR /*pnmh*/, BOOL& /*bHandled*/)

	LRESULT OnInitDialog(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/);
	LRESULT OnDestory(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/);
	LRESULT OnHScroll(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/);
	LRESULT OnAppAbout(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);
	LRESULT OnOK(WORD /*wNotifyCode*/, WORD wID, HWND /*hWndCtl*/, BOOL& /*bHandled*/);
	LRESULT OnCancel(WORD /*wNotifyCode*/, WORD wID, HWND /*hWndCtl*/, BOOL& /*bHandled*/);
	
	void	InitEffectAndTransition();
	void	LoadEffects();
	void	LoadTransitions();

	DWORD	DoProgress(LONGLONG dwPercent, BOOL bCallFromGUI);
	static DWORD WINAPI	OnProgress(LONGLONG dwPercent, BOOL bCallFromGUI);
	
	inline void SetImageToDlg(LPBYTE bits)
	{
		
		HDC hDC = GetDC();
		SetDIBitsToDevice(hDC, 8, 4, m_BitmapInfo.biWidth, m_BitmapInfo.biHeight, 0, 0, 0, m_BitmapInfo.biHeight, 
			bits, (const BITMAPINFO*)&m_Info, DIB_RGB_COLORS);
		ReleaseDC(hDC);
	}

private:
	// members
	HBRUSH				m_BackGround;
	CWndThumbnail		m_Thumbnail;	// thumbnail display window
	CSImage*			m_ImageA;		// input 0
	CSImage*			m_ImageB;		// input 1
	CSImage*			m_ImageC;		// output
	BITMAPINFOHEADER	m_BitmapInfo;	
	BITMAPINFOHEADER	m_Info;
	DWORD				m_SelectedEffect;
	
	LONG				m_ThumbnailSize;
	LPBYTE				m_ThumbnailBits;
	BITMAPINFOHEADER	m_ThumbnailInfo;
	
	HEFFECT				m_Effect;
	HTRANSITION			m_Transition;

	// controls
	CListBox			m_CtrlEffectList;
	CStatic				m_CtrlName;
	CStatic				m_CtrlDescription;
	CTrackBarCtrl		m_CtrlProgress;
	CEffectPlayer		m_Player;
	static CMainDlg*	m_Impl;
	DWORD				m_EffectType;

public:
	LRESULT OnBnClickedButtonA(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);
	LRESULT OnBnClickedButtonB(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);
	LRESULT OnEffectChangled(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);
	LRESULT OnBnClickedButtonPlay(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);
	LRESULT OnBnClickedButtonPause(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);
	LRESULT OnBnClickedEffect(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);
	LRESULT OnBnClickedTransition(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);
};
