#pragma once

class CSDProject;

class SIMAGE_API CSDPicture
{
public:
	CSDPicture(CSDProject* pProject);
	CSDPicture(CSDProject* pProject, LPCWSTR FileName, LONG lTransition);
	virtual ~CSDPicture(void);
	static LONG	IsValid(LPCWSTR);
	
	LONG		SetTransition(LPCWSTR);
	LONG		SetTransitionByID(LONG);
	LPCWSTR		GetFileName()					{ return m_FileName; }
	LPCWSTR		GetTransitionName()				{ return m_TransitionName; }
	LONG		GetTransition()					{ return m_Transition; }
	LONG		GetRotateAngle()				{ return m_RotateAngle; }
	LONGLONG	GetDuration()					{ return m_Duration; }
	void		SetDuration(LONG lDuration)		{ m_Duration = lDuration; }
	void		SetRotateAngle(LONG dwAngle);
	CSDPicture*	GetPrevious()					{ return m_Previous; }
	CSDPicture*	GetNext()						{ return m_Next; }
	void		SetPrevious(CSDPicture* pPic)	{ m_Previous = pPic; }
	void		SetNext(CSDPicture* pPic)		{ m_Next = pPic; }
	LONG		GetID()							{ return m_ID; }
	void		SetID(LONG lID)					{ m_ID = lID; }
	CSDProject*	GetProject()					{ return m_Project; }

private:
	CSDProject*	m_Project;
	LONG		m_ID;
	LONG		m_Transition;
	LONG		m_RotateAngle;
	LONGLONG	m_Duration;
	CSDPicture*	m_Previous;
	CSDPicture*	m_Next;
	LPWSTR		m_FileName;
	WCHAR		m_TransitionName[256];
};