#pragma once

#include <list>
#include <vector>

#pragma warning(disable:4251)

class SIMAGE_API CSDProject
{
public:
	class SIMAGE_API CTransition
	{
	public:
		CTransition(LPCWSTR, DWORD dwTransition);
		virtual ~CTransition();

		inline LPCWSTR				GetName()	{ return m_Name; }
		inline DWORD				GetID()		{ return m_Id; }
		
	private:
		LPWSTR						m_Name;
		DWORD						m_Id;
	};

	class SIMAGE_API CTransitionGroup
	{
	public:
		CTransitionGroup(LPCWSTR, LONG iLength);
		virtual ~CTransitionGroup();
		inline LPCWSTR				GetName()	{ return m_Name; }
		inline INT					GetNum()	{ return static_cast<INT>(m_Transitions.size()); }
		inline CTransition*			GetTransition(int iTransition) { return m_Transitions[iTransition]; }
		void						AddTransition(LPCWSTR, DWORD dwTransitionID);

	private:
		LPWSTR									m_Name;
		std::vector<CSDProject::CTransition*>	m_Transitions;
	};

	CSDProject(void);
	virtual ~CSDProject(void);
	void							Init();
	LONG							IsEmpty();
	LONG							IsModified()		{ return m_Modified; }
	void							Empty();
	LONG							Save();
	LONG							SaveAs(LPCWSTR);
	LONG							Open(LPCWSTR);
	
	LONGLONG						GetTransitionDuration() { return m_TransitionDuration; }
	LONG							SetTransitionDuration(LONGLONG);
	LONGLONG						GetPerDuration() { return m_PerDuration; }
	LONG							SetPerDuration(LONGLONG lDuration);
	LONG							SetOutputSize(LONG lWidth, LONG lHeight);
	void							GetOutputSize(LONG* lWidth, LONG* lHeight)	{ if (lWidth) *lWidth = m_Width; if (lHeight) *lHeight = m_Height; }
	LONG							GetOutputFileFormat()						{ return m_FileType; }
	LONG							SetOutputFileFormat(LONG lFileType);
	LONG							GetQuality()								{ return m_Quality; }
	LONG							SetQuality(LONG);
	LONG							GetCodec()									{ return m_Codec; }
	LONG							SetCodec(LONG);
	LONG							GetSizeType()								{ return m_SizeType; }
	LONG							SetSizeType(LONG lType);
	LONG							GetClassicSize()							{ return m_ClassicSize; }
	LONG							SetClassicSize(LONG);

	CSDPicture*						ImportPicture(LPCWSTR);
	LONG							RemovePicture(CSDPicture*);
	LONG							GetMinRefTransition();
	CSDPicture*						GetPicture(LONG);
	DWORD							GetPictureNum()							{ return static_cast<DWORD>(m_Pictures.size()); }
	LONG							SwapPicture(CSDPicture* pL, CSDPicture* pR);
	LPCWSTR							GetFileName()							{ return m_FileName; }
	LPCWSTR							GetName()								{ if (m_Name[0] == 0) return NULL; return m_Name; }
	LONG							SetName(LPCWSTR);
	LONG							SetFileName(LPCWSTR); // 0: wrong parameters, 1: succeeded, 2: same filename
	LONG							GetTransitionGroupNum()					{ return static_cast<LONG>(m_TransitionGroups.size()); }
	CTransitionGroup*				GetTransitionGroup(INT iGroup)			{ return m_TransitionGroups[iGroup]; }
	
private:
	void							Clear();
	CTransitionGroup*				GetTransitionGroup(LPCWSTR, LONG lLength);
	
private:
	LONG							m_Modified;
	LONG							m_FileType;
	LONG							m_Codec;
	LONG							m_ClassicSize;
	LONG							m_SizeType;
	LONG							m_Quality;
	LONG							m_Width;
	LONG							m_Height;
	LONGLONG						m_PerDuration;
	LONGLONG						m_TransitionDuration;
	DWORD							m_TransitionNum;
	DWORD							m_TransitionGenerateID;
	WCHAR							m_Name[256];
	LPWSTR							m_FileName;

	std::list<CSDPicture*>			m_Pictures;
	std::vector<CTransitionGroup*>	m_TransitionGroups;
};