// MainDlg.cpp : implementation of the CMainDlg class
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "resource.h"
#include "AboutDlg.h"
#include "MainDlg.h"
#include <atltypes.h>

CMainDlg* CMainDlg::m_Impl = 0;

LRESULT CMainDlg::OnInitDialog(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/)
{
	// center the dialog on the screen
	CenterWindow();

	m_BackGround = ::CreateSolidBrush(RGB(128, 128, 128));

	// set icons
	HICON hIcon = (HICON)::LoadImage(_Module.GetResourceInstance(), MAKEINTRESOURCE(IDR_MAINFRAME), 
		IMAGE_ICON, ::GetSystemMetrics(SM_CXICON), ::GetSystemMetrics(SM_CYICON), LR_DEFAULTCOLOR);
	SetIcon(hIcon, TRUE);
	HICON hIconSmall = (HICON)::LoadImage(_Module.GetResourceInstance(), MAKEINTRESOURCE(IDR_MAINFRAME), 
		IMAGE_ICON, ::GetSystemMetrics(SM_CXSMICON), ::GetSystemMetrics(SM_CYSMICON), LR_DEFAULTCOLOR);
	SetIcon(hIconSmall, FALSE);

	// init controls
	CButton btnCheckTransition = GetDlgItem(IDC_RADIO_TRANSITION);
	btnCheckTransition.SetCheck(BST_CHECKED);

	m_CtrlEffectList = GetDlgItem(IDC_LIST_EFFECTS);
	m_CtrlName = GetDlgItem(IDC_NAME);
	m_CtrlDescription = GetDlgItem(IDC_DESCRIPTION);
	
	CRect rcThumbnail;
	::GetWindowRect(m_CtrlName.m_hWnd, &rcThumbnail);
	ScreenToClient(rcThumbnail);
	rcThumbnail.top = rcThumbnail.bottom + 4;
	rcThumbnail.bottom = rcThumbnail.top + 77;
	rcThumbnail.right = rcThumbnail.left + 77;
	m_Thumbnail.Create(m_hWnd, &rcThumbnail, NULL, WS_VISIBLE|WS_CHILD, 0, 1200);

	// create images
	ZeroMemory(&m_BitmapInfo, sizeof(m_BitmapInfo));
	m_BitmapInfo.biBitCount		 = 32;
	m_BitmapInfo.biCompression	 = BI_RGB;
	m_BitmapInfo.biPlanes		 = 1;
	m_BitmapInfo.biSize			 = sizeof(BITMAPINFOHEADER);
	m_BitmapInfo.biXPelsPerMeter = 0xEC4;
	m_BitmapInfo.biYPelsPerMeter = 0xEC4;
	m_Info = m_BitmapInfo;

	WCHAR Directory[256];
	WCHAR FileName[512];
	GetModuleFileNameW(NULL, Directory, 256);
	PathRemoveFileSpec(Directory);
	
	swprintf(FileName, L"%s\\pics\\A.png", Directory);
	m_ImageA = new CSImage(FileName);
	
	swprintf(FileName, L"%s\\pics\\B.png", Directory);
	m_ImageB = new CSImage(FileName);
	if (m_ImageB->Width() != m_ImageA->Width() || m_ImageB->Height() != m_ImageA->Height()) {
		CSImage* pTemp = new CSImage(m_ImageA->Width(), m_ImageA->Height());
		m_ImageB->ResizeTo(pTemp, 0);
		delete m_ImageB;
		m_ImageB = pTemp;
	}
	m_ImageC = new CSImage(m_ImageA->Width(), m_ImageA->Height());

	m_BitmapInfo.biWidth = m_ImageA->Width();
	m_BitmapInfo.biHeight = m_ImageA->Height();
	m_BitmapInfo.biSizeImage = m_ImageA->Width() * m_ImageA->Height() * 4;
	m_Info = m_BitmapInfo;
	m_Info.biHeight = - m_BitmapInfo.biHeight;

	SetImageToDlg(m_ImageA->GetBits());
	
	InitEffectAndTransition();
	LoadTransitions();

	m_Player.m_ImageA = m_ImageA;
	m_Player.m_ImageB = m_ImageB;
	m_Player.m_ImageC = m_ImageC;
	m_Player.m_BitmapInfo = &m_BitmapInfo;

	m_Player.Init();
	m_Player.SetProgressFunc(OnProgress);

	::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_PLAY),  FALSE);
	::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_PAUSE), FALSE);

	m_CtrlProgress = GetDlgItem(IDC_SLIDER_PROGRESS);
	m_CtrlProgress.SetRange(0, 100);
	return TRUE;
}

LRESULT CMainDlg::OnDestory(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/)
{
	return TRUE;
}

LRESULT CMainDlg::OnHScroll(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/)
{
	DWORD dwPos = m_CtrlProgress.GetPos();
	m_Player.SetPercent(dwPos);
	return S_OK;
}

void CMainDlg::InitEffectAndTransition()
{
	WCHAR Directory[1024];
	GetModuleFileNameW(NULL, Directory, 1024);
	PathRemoveFileSpec(Directory);
	wcscat(Directory, L"\\effect");
	SInitEffectLibrary(Directory);

	GetModuleFileNameW(NULL, Directory, 1024);
	PathRemoveFileSpec(Directory);
	wcscat(Directory, L"\\transition");
	SInitTransitionLibrary(Directory);
}

void CMainDlg::LoadEffects()
{
	m_CtrlEffectList.ResetContent();

	DWORD dwCount = SGetEffectCount();
	for (DWORD i = 0; i < dwCount; i++) {
		LPCWSTR strName = SGetEffectName(i);
		int iSel = m_CtrlEffectList.AddString(strName);
		m_CtrlEffectList.SetItemData(iSel, i);
	}
}

void CMainDlg::LoadTransitions()
{
	m_CtrlEffectList.ResetContent();

	DWORD dwCount = SGetTransitionCount();
	for (DWORD i = 0; i < dwCount; i++) {
		LPCWSTR strName = SGetTransitionName(i);
		int iSel = m_CtrlEffectList.AddString(strName);
		m_CtrlEffectList.SetItemData(iSel, i);
	}
}

LRESULT CMainDlg::OnAppAbout(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	CAboutDlg dlg;
	dlg.DoModal();
	return 0;
}

LRESULT CMainDlg::OnOK(WORD /*wNotifyCode*/, WORD wID, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	// TODO: Add validation code 
	m_Player.Exit();

	if (m_ImageA) delete m_ImageA, m_ImageA = 0;
	if (m_ImageB) delete m_ImageB, m_ImageB = 0;
	if (m_ImageC) delete m_ImageC, m_ImageC = 0;
	if (m_EffectType == CEffectPlayer::EFFECT_EFFECT) {
		if (m_Effect) SCloseEffect(m_Effect);
		m_Effect = 0;
	}
	else {
		if (m_Transition) SCloseTransition(m_Transition);
		m_Transition = 0;
	}

	EndDialog(wID);
	return 0;
}

LRESULT CMainDlg::OnCancel(WORD /*wNotifyCode*/, WORD wID, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	m_Player.Exit();

	if (m_ImageA) delete m_ImageA, m_ImageA = 0;
	if (m_ImageB) delete m_ImageB, m_ImageB = 0;
	if (m_ImageC) delete m_ImageC, m_ImageC = 0;

	if (m_EffectType == CEffectPlayer::EFFECT_EFFECT) {
		if (m_Effect) SCloseEffect(m_Effect);
		m_Effect = 0;
	}
	else {
		if (m_Transition) SCloseTransition(m_Transition);
		m_Transition = 0;
	}

	EndDialog(wID);
	return 0;
}

LRESULT CMainDlg::OnBnClickedButtonA(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	// TODO: Add your control notification handler code here

	return 0;
}

LRESULT CMainDlg::OnBnClickedButtonB(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	// TODO: Add your control notification handler code here

	return 0;
}

LRESULT CMainDlg::OnEffectChangled(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	// TODO: Add your control notification handler code here
	int iCurSel = m_CtrlEffectList.GetCurSel();
	if (iCurSel >= 0 && m_SelectedEffect != iCurSel) {
		m_Player.Pause();

		DWORD dwID = (DWORD)m_CtrlEffectList.GetItemData(iCurSel);
		LONG  lSize = 0;

		if (m_EffectType == CEffectPlayer::EFFECT_EFFECT) SGetEffectThumbnail(dwID, 0, 0, 0, &lSize);
		else SGetTransitionThumbnail(dwID, 0, 0, 0, &lSize);
		
		if (lSize > 0) {
			if (lSize != m_ThumbnailSize) {
				m_ThumbnailSize = lSize;
				if (m_ThumbnailBits) delete[] m_ThumbnailBits, m_ThumbnailBits = 0;
			}
			if (m_ThumbnailBits == 0) {
				m_ThumbnailBits = new BYTE[m_ThumbnailSize];
			}

			if (m_EffectType == CEffectPlayer::EFFECT_EFFECT) 
				SGetEffectThumbnail(dwID, 0, &m_ThumbnailInfo, (LONG*)m_ThumbnailBits, &m_ThumbnailSize);
			else
				SGetTransitionThumbnail(dwID, 0, &m_ThumbnailInfo, (LONG*)m_ThumbnailBits, &m_ThumbnailSize);

			m_Thumbnail.SetImage(&m_ThumbnailInfo, m_ThumbnailBits);
		}
		if (m_EffectType == CEffectPlayer::EFFECT_EFFECT) {
			HEFFECT hEffect = SCreateEffect(dwID, 0);
			m_Player.SetEffect(hEffect);

			if (m_Effect) SCloseEffect(m_Effect);
			m_Effect = hEffect;
			m_SelectedEffect = iCurSel;
		
			m_CtrlName.SetWindowText(SGetEffectName(dwID));
			m_CtrlDescription.SetWindowText(SGetEffectDescription(dwID));
		}
		else {
			HTRANSITION hEffect = SCreateTransition(dwID, 0);
			m_Player.SetTransition(hEffect);

			if (m_Transition) SCloseTransition(m_Transition);
			m_Transition = hEffect;
			m_SelectedEffect = iCurSel;
		
			m_CtrlName.SetWindowText(SGetTransitionName(dwID));
			m_CtrlDescription.SetWindowText(SGetTransitionDescription(dwID));


			// generate logo
			/*{
				CSImage imageA(L"D:\\xrkl.png");
				CSImage imageB(128, 128);
				CSImage imageD(128, 128);
				m_Transition->DoEffect(&imageD, &imageA, &imageB, 40);
				imageD.Save(L"D:\\thumbnail.bmp");
			}*/
		}

		m_CtrlProgress.EnableWindow(FALSE);

		m_Player.Play();
		
		::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_PLAY),  FALSE);
		::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_PAUSE), TRUE);
		
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_PLAY),  SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_PAUSE), SW_SHOW);
	}
	return 0;
}

LRESULT CMainDlg::OnBnClickedButtonPlay(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	// TODO: Add your control notification handler code here
	if (m_Effect || m_Transition) {
		m_Player.Play();
		::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_PLAY),  FALSE);
		::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_PAUSE), TRUE);

		::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_PLAY),  SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_PAUSE), SW_SHOW);

		m_CtrlProgress.EnableWindow(FALSE);
	}	
	return 0;
}

DWORD CMainDlg::OnProgress(LONGLONG dwPercent, BOOL bCallFromGUI) 
{
	m_Impl->DoProgress(dwPercent, bCallFromGUI);
	return 0;
}

DWORD CMainDlg::DoProgress(LONGLONG dwPercent, BOOL bCallFromGUI)
{
	SetImageToDlg(m_ImageC->GetBits());
	if (bCallFromGUI != TRUE) {
		if (dwPercent >= 100) {
			::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_PLAY),  TRUE);
			::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_PAUSE), FALSE);

			::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_PAUSE), SW_HIDE);
			::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_PLAY),  SW_SHOW);
			
			m_CtrlProgress.EnableWindow(TRUE);
			dwPercent = 100;
		}
		
		m_CtrlProgress.SetPos((DWORD)dwPercent);
	}

	return 0;
}

LRESULT CMainDlg::OnBnClickedButtonPause(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	// TODO: Add your control notification handler code here
	if (m_Effect || m_Transition) {
		::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_PLAY),  TRUE);
		::EnableWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_PAUSE), FALSE);
		m_Player.Pause();
		
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_PAUSE), SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON_PLAY),  SW_SHOW);
	}
	return 0;
}

LRESULT CMainDlg::OnBnClickedEffect(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	// TODO: Add your control notification handler code here
	if (m_EffectType == CEffectPlayer::EFFECT_EFFECT) return S_OK;
	m_EffectType = CEffectPlayer::EFFECT_EFFECT;
	LoadEffects();
	m_SelectedEffect = -1;
	return S_OK;
}

LRESULT CMainDlg::OnBnClickedTransition(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	// TODO: Add your control notification handler code here
	if (m_EffectType == CEffectPlayer::EFFECT_TRANSITION) return S_OK;
	m_EffectType = CEffectPlayer::EFFECT_TRANSITION;
	LoadTransitions();
	m_SelectedEffect = -1;
	return S_OK;
}
