// DemoSDDlg.cpp : implementation file
//

#include "stdafx.h"
#include "DemoSD.h"
#include "DemoSDDlg.h"
#include <shlwapi.h>
#include "_SlidePL_i.c"
#include ".\demosddlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()


// CDemoSDDlg dialog


CDemoSDDlg*	CDemoSDDlg::m_Impl = 0;

CDemoSDDlg::CDemoSDDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDemoSDDlg::IDD, pParent)
	, m_SDFactory(NULL)
	, m_ImageA(NULL)
	, m_ImageB(NULL)
	, m_ImageC(NULL)
	, m_Transition(0)
	, m_Bits(0)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CDemoSDDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST_EFFECTS, m_CtrlTransitions);
}

BEGIN_MESSAGE_MAP(CDemoSDDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_BTN_PLAY, OnBnClickedBtnPlay)
	ON_BN_CLICKED(IDC_BTN_PAUSE, OnBnClickedBtnPause)
	ON_LBN_SELCHANGE(IDC_LIST_EFFECTS, OnLbnSelchangeListEffects)
END_MESSAGE_MAP()


// CDemoSDDlg message handlers

BOOL CDemoSDDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.
	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here

	if (!Init())
		return FALSE;

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CDemoSDDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CDemoSDDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CDemoSDDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CDemoSDDlg::OnDestroy()
{
	CDialog::OnDestroy();

	// TODO: Add your message handler code here
	if (m_ImageA) m_ImageA->Release(), m_ImageA = 0;
	if (m_ImageB) m_ImageB->Release(), m_ImageB = 0;
	if (m_ImageC) m_ImageC->Release(), m_ImageC = 0;
	if (m_Transition) m_Transition->Release(), m_Transition = 0;
	if (m_SDFactory) m_SDFactory->Release(), m_SDFactory = 0;
	if (m_Bits) delete[] m_Bits, m_Bits = 0;
}

BOOL CDemoSDDlg::Init()
{
	// Initialize the COM library
	::CoInitialize(NULL);
	
	// Create the factory
	HRESULT hr = CoCreateInstance(CLSID_CSlideFactory, NULL, CLSCTX_INPROC_SERVER, IID_ISlideFactory, (void**)&m_SDFactory);
	if (FAILED(hr) || m_SDFactory == 0) {
		return FALSE;
	}

	// Set plug-in dir
	WCHAR Dir[256];
	GetModuleFileNameW(NULL, Dir, 256);
	PathRemoveFileSpec(Dir);
	wcscat(Dir, L"\\transition");
	m_SDFactory->SetTransitionDir((BSTR)Dir);

	// Add all transition's name into the listbox
	LONG lTransitionNum = 0;
	m_SDFactory->GetTransitionCount(&lTransitionNum);
	for (LONG i = 0; i < lTransitionNum; i++) {
		CComBSTR bstrName;
		m_SDFactory->GetTransitionName(i, &bstrName);
		m_CtrlTransitions.AddString((BSTR)bstrName);
	}

	// load the image A
	GetModuleFileNameW(NULL, Dir, 256);
	PathRemoveFileSpec(Dir);
	wcscat(Dir, L"\\pics\\A.png");
	hr = CoCreateInstance(CLSID_CSlideImage, NULL, CLSCTX_INPROC_SERVER, IID_ISlideImage, (void**)&m_ImageA);
	if (FAILED(hr) || m_ImageA == 0) 
		return FALSE;
	m_ImageA->LoadFile(Dir);
	
	// load the image B
	GetModuleFileNameW(NULL, Dir, 256);
	PathRemoveFileSpec(Dir);
	wcscat(Dir, L"\\pics\\B.png");
	hr = CoCreateInstance(CLSID_CSlideImage, NULL, CLSCTX_INPROC_SERVER, IID_ISlideImage, (void**)&m_ImageB);
	if (FAILED(hr) || m_ImageB == 0) 
		return FALSE;
	m_ImageB->LoadFile(Dir);

	// make sure the image A and image B has same width and height
	if (m_ImageA->GetHeight(NULL) != m_ImageB->GetHeight(NULL) || m_ImageA->GetWidth(NULL) != m_ImageB->GetWidth(NULL))
		return FALSE;

	// create image C
	hr = CoCreateInstance(CLSID_CSlideImage, NULL, CLSCTX_INPROC_SERVER, IID_ISlideImage, (void**)&m_ImageC);
	if (FAILED(hr) || m_ImageC == 0) 
		return FALSE;
	m_ImageC->SetSize(m_ImageA->GetWidth(NULL), m_ImageA->GetHeight(NULL));
	m_Bits = new BYTE[m_ImageC->GetPitch(NULL) * m_ImageC->GetHeight(NULL)];

	ZeroMemory(&m_BitmapInfo, sizeof(m_BitmapInfo));
	m_BitmapInfo.biBitCount		 = 32;
	m_BitmapInfo.biCompression	 = BI_RGB;
	m_BitmapInfo.biPlanes		 = 1;
	m_BitmapInfo.biSize			 = sizeof(BITMAPINFOHEADER);
	m_BitmapInfo.biXPelsPerMeter = 0xEC4;
	m_BitmapInfo.biYPelsPerMeter = 0xEC4;
	m_Info						 = m_BitmapInfo;

	m_Impl = this;
	m_Player.m_ImageA = m_ImageA;
	m_Player.m_ImageB = m_ImageB;
	m_Player.m_ImageC = m_ImageC;
	
	m_BitmapInfo.biWidth		= m_ImageA->GetWidth(NULL);
	m_BitmapInfo.biHeight		= m_ImageA->GetHeight(NULL);
	m_BitmapInfo.biSizeImage	= m_BitmapInfo.biWidth * m_BitmapInfo.biHeight * 4;
	m_Info						= m_BitmapInfo;
	m_Info.biHeight				= - m_BitmapInfo.biHeight;

	m_Player.Init();
	m_Player.SetProgressFunc(OnProgress);
	
	return TRUE;
}

DWORD CDemoSDDlg::OnProgress(LONGLONG dwPercent, BOOL bCallFromGUI) 
{
	m_Impl->DoProgress(dwPercent, bCallFromGUI);
	return 0;
}

DWORD CDemoSDDlg::DoProgress(LONGLONG dwPercent, BOOL bCallFromGUI)
{
	if (SUCCEEDED(m_ImageC->GetBits(m_Bits, m_ImageC->GetPitch(NULL)))) {
		SetImageToDlg(m_Bits);
	}

	if (bCallFromGUI != TRUE) {
		if (dwPercent >= 100) {
			::EnableWindow(::GetDlgItem(m_hWnd, IDC_BTN_PLAY),  TRUE);
			::EnableWindow(::GetDlgItem(m_hWnd, IDC_BTN_PAUSE), FALSE);
		}
	}

	return 0;
}

void CDemoSDDlg::OnBnClickedBtnPlay()
{
	m_Player.Play();
	::EnableWindow(::GetDlgItem(m_hWnd, IDC_BTN_PLAY),  FALSE);
	::EnableWindow(::GetDlgItem(m_hWnd, IDC_BTN_PAUSE), TRUE);
}

void CDemoSDDlg::OnBnClickedBtnPause()
{
	m_Player.Pause();
	::EnableWindow(::GetDlgItem(m_hWnd, IDC_BTN_PLAY),  TRUE);
	::EnableWindow(::GetDlgItem(m_hWnd, IDC_BTN_PAUSE), FALSE);

}

void CDemoSDDlg::OnLbnSelchangeListEffects()
{
	int iCurSel = m_CtrlTransitions.GetCurSel();
	if (iCurSel >= 0) {
		m_Player.Pause();

		ISlideTransition* pTransition = 0;
		m_SDFactory->CreateTransition(iCurSel, 0, &pTransition);
		if (pTransition) {
			if (m_Transition) m_Transition->Release(), m_Transition = 0;
			m_Transition = pTransition;
			
			m_Player.SetTransition(pTransition);
		}		
	}
	m_Player.Play();
		
	::EnableWindow(::GetDlgItem(m_hWnd, IDC_BTN_PLAY),  FALSE);
	::EnableWindow(::GetDlgItem(m_hWnd, IDC_BTN_PAUSE), TRUE);
}
