#pragma once

#include <objidl.h>

class CSImage;

class SIMAGE_API CSEffect
{
public:
	//
	// constructor
	//
	CSEffect() : m_EffectID(-1)
	{
	}

	//
	// destructor
	//
	virtual ~CSEffect(void)
	{
	}

	// 
	// Do the effect
	//
	virtual LRESULT DoEffect(CSImage* pImageOut, CSImage* pImageIn, LONGLONG llPercent = 0, LONGLONG llFlag = 0) = 0;

	//
	// the function is been called while being created
	//
	virtual LRESULT	OnCreate(LONGLONG llData) { m_EffectUserData = llData; return S_OK; }

	//
	// the function is been called while being destroied
	//
	virtual LRESULT OnDestroy() { return S_OK; }
	
	//
	// get effect id
	//
	DWORD	GetID() { return m_EffectID; }

	//
	// set effect id
	//
	void	SetID(DWORD dwID) { m_EffectID = dwID; }

	//
	// get user data
	//
	LONGLONG GetUserData() { return m_EffectUserData; }

	LRESULT	GetAttributeDefault(LPCWSTR, LONGLONG& llDefault) 
	{ 
		llDefault = 0;
		return S_OK; 
	}

	LRESULT	GetAttribute(LPCWSTR, LONGLONG& llGetted)
	{
		llGetted = 0;
		return S_OK; 
	}

	LRESULT SetAttribute(LPCWSTR, LONGLONG)
	{
		return S_OK;
	}

	LRESULT	GetAttributeRangle(LPCWSTR, LONGLONG& llMin, LONGLONG& llMax)
	{
		llMin = llMax = 0;
		return S_OK;
	}

protected:
	DWORD		m_EffectID;
	LONGLONG	m_EffectUserData;
};

typedef CSEffect* HEFFECT;
