#pragma once

#include <objidl.h>

class CSImageChannel;

class SIMAGE_API CSImage 
{
public:
	// constructor
	CSImage(void);
	CSImage(LPCWSTR);
	CSImage(IStream*);
	CSImage(long /*width*/, long /*height*/);
	CSImage(LPBYTE /*bits*/, LONGLONG /*lSize*/);
	CSImage(const CSImage&);
	virtual ~CSImage();

	void Release();
	inline long IsReady() const { return m_Ready; }
	inline long Width() const { return m_Width; }
	inline long Height() const { return m_Height; }
	inline long Pitch() const { return m_Pitch; }
	inline LPBYTE GetBits() { return m_Bits; }
	inline LPBYTE GetConstBits() const { return m_Bits; }
	inline void SetFree(long lFree) { m_Free = lFree; }
	inline long GetFree(void) { return m_Free; }

	long Save(LPCWSTR); // only support saving as bmp
	void SetSize(long width, long height);
	void Fill(BYTE a, BYTE r, BYTE g, BYTE b);
	void Attach(long width, long height, long pitch, LPBYTE bits);
	long LoadStream(IStream* pStream);
	long LoadFile(LPCWSTR);
	long LoadBits(LPBYTE /*bits*/, LONGLONG /*lCount*/);
	void CopyFrom(const CSImage*);
	void ResizeTo(CSImage* pImageD, long iInterpolation = 0) const;	// iInterpolation == 0: Bilinear, iInterpolation ==1 : ThreeOrder
	void DrawImage(const CSImage* PImage, long x, long y);
	long GetFileType(LPBYTE); // 0: bmp, 1: jpeg, 2: png, -1: unsupported
	void ExtractChannel(long lChannel, CSImageChannel*); // 0: b, 1: g, 2: r, 3, a
	void Rotate(CSImage* pImageD, long lAngle);

protected:
	long	m_Ready;
	long	m_Free;
	long	m_Width;
	long	m_Height;
	long	m_Pitch;
	LPBYTE	m_Bits;
};
