#include "StdAfx.h"
#include "Hyperlink.h"
#include <shellapi.h>

CHyperLink::CHyperLink(void)
	: m_ProcOrigin(0)
	, m_hWnd(0)
	, m_Font(0)
	, m_BackGround(0)
	, m_Link(L"http://www.e2esoft.cn/slideshow/sdk.asp")
{
}

CHyperLink::~CHyperLink(void)
{
}

BOOL CHyperLink::Subclass(HWND hWnd)
{
	HFONT hFont = (HFONT)::SendMessage(hWnd, WM_GETFONT, 0, 0);
	if (hFont == 0) return FALSE;
	LOGFONT LogFont;
	GetObject(hFont, sizeof(LOGFONT), &LogFont);
	LogFont.lfUnderline = (BYTE)TRUE;
	m_Font = ::CreateFontIndirect(&LogFont);

	LOGBRUSH LogBrush;
	LogBrush.lbColor = GetSysColor(COLOR_3DFACE);
	LogBrush.lbStyle = BS_SOLID;
	LogBrush.lbHatch = 0;
	m_BackGround = ::CreateBrushIndirect(&LogBrush);

	TCHAR strCaption[256];
	::GetWindowText(hWnd, strCaption, 256);
	m_Caption = strCaption;

	m_hWnd = hWnd;
	SetWindowLongPtr(hWnd, GWLP_USERDATA, reinterpret_cast<LONG_PTR>(this));

#ifdef _WIN64
	m_ProcOrigin = (WNDPROC)GetWindowLongPtr(hWnd, GWLP_WNDPROC);
	LONG_PTR nResult = SetWindowLongPtr(hWnd, GWLP_WNDPROC, (LONG_PTR)LinkProc);
#else
	m_ProcOrigin = (WNDPROC)GetWindowLongPtr(hWnd, GWLP_WNDPROC);
	LONG_PTR nResult = SetWindowLongPtr(hWnd, GWLP_WNDPROC, (LONG)(LONG_PTR)LinkProc);
#endif 

	return TRUE;
}

BOOL CHyperLink::UnSubclass()
{
	if (m_ProcOrigin == 0 || m_hWnd == 0) return FALSE;

#ifdef _WIN64
	LONG_PTR nResult = SetWindowLongPtr(m_hWnd, GWLP_WNDPROC, (LONG_PTR)m_ProcOrigin);
#else
	LONG_PTR nResult = SetWindowLongPtr(m_hWnd, GWLP_WNDPROC, (LONG)(LONG_PTR)m_ProcOrigin);
#endif

	if (m_Font) {
		::DeleteObject(m_Font);
		m_Font = 0;
	}

	if (m_BackGround) {
		::DeleteObject(m_BackGround);
		m_BackGround = 0;
	}

	return TRUE;
}

LRESULT CALLBACK CHyperLink::LinkProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	CHyperLink* pImpl = (CHyperLink*)GetWindowLongPtr(hWnd, GWLP_USERDATA);
	if (pImpl == 0) {
		return DefWindowProc(hWnd, uMsg, wParam, lParam);
	}

	switch (uMsg)
	{
	case WM_ERASEBKGND:
		{
			HDC hDC = (HDC)wParam;
			RECT rcClient;
			::GetClientRect(hWnd, &rcClient);
			::FillRect(hDC, &rcClient, pImpl->m_BackGround);
		}
		break;

	case WM_PAINT:
		{
			RECT rcClient;
			::GetClientRect(hWnd, &rcClient);

			
			PAINTSTRUCT ps = {NULL};
			HDC hdc = BeginPaint(hWnd, &ps);

			HGDIOBJ hOldFont = ::SelectObject(hdc, (HGDIOBJ)pImpl->m_Font);

			::SetTextColor(hdc, RGB(0, 0, 255));
			::SetBkMode(hdc, TRANSPARENT);
			::DrawText(hdc, pImpl->m_Caption.c_str(), -1, &rcClient, DT_CENTER|DT_VCENTER);
			
			::SelectObject(hdc, hOldFont);
			EndPaint(hWnd, &ps);
			
		}
		break;

	case WM_SETCURSOR:
		{
			HCURSOR hHand = ::LoadCursor(NULL, IDC_HAND);
			::SetCursor(hHand);
			return 0;
		}
		break;

	case WM_LBUTTONDOWN:
		{
			pImpl->GotoURL();
		}
		break;
	}
	return DefWindowProc(hWnd, uMsg, wParam, lParam);
}


BOOL CHyperLink::GotoURL()
{
	HINSTANCE result = ShellExecute(NULL, _T("open"), m_Link.c_str(), NULL,NULL, SW_SHOWNORMAL);
	if ((UINT)result <= HINSTANCE_ERROR) {
		return FALSE;
	}
	return TRUE;
}