#include "StdAfx.h"
#include "WndThumbnail.h"

CWndThumbnail::CWndThumbnail(void) : m_Image(0)
{
}

CWndThumbnail::~CWndThumbnail(void)
{
	if (m_Image) delete m_Image, m_Image = 0;
}

void CWndThumbnail::DoPaint(CDCHandle hDC)
{
	Gdiplus::Graphics GdiplusDC(hDC);
	
	DWORD dwBackCl = GetSysColor(COLOR_3DFACE);
	BYTE r = dwBackCl >> 16;
	BYTE g = dwBackCl >> 8;
	BYTE b = dwBackCl & 0xFF;

	RECT rcClient;
	GetClientRect(&rcClient);
	
	Gdiplus::SolidBrush brush(Gdiplus::Color(255, r, g, b));
	GdiplusDC.FillRectangle(&brush, 0, 0, rcClient.right, rcClient.bottom);

	if (m_Image) {
		Gdiplus::Rect rt(rcClient.left, rcClient.top, rcClient.right - rcClient.left, rcClient.bottom - rcClient.top);
		GdiplusDC.DrawImage(m_Image, rt, 0, 0, m_Image->GetWidth(), m_Image->GetHeight(), Gdiplus::UnitPixel);
	}
}