#pragma once

#include <gdiplus.h>

class CWndThumbnail : public CWindowImpl<CWndThumbnail>
	, public CDoubleBufferImpl<CWndThumbnail>
{
public:
	enum
	{
		UWM_SETIMAGE = WM_APP + 100,
	};

	struct SETIMAGE
	{
		const BITMAPINFOHEADER* info;
		LPBYTE bits;
	};

	CWndThumbnail(void);
	virtual ~CWndThumbnail(void);

	BEGIN_MSG_MAP(CWndThumbnail)
		MESSAGE_HANDLER(UWM_SETIMAGE,					OnSetImage)
		CHAIN_MSG_MAP(CDoubleBufferImpl<CWndThumbnail>)
	END_MSG_MAP()

	void	DoPaint(CDCHandle);
	void SetImage(const BITMAPINFOHEADER* info, LPBYTE bits) 
	{ 
		SETIMAGE setImage;
		setImage.info = info;
		setImage.bits = bits;
		SendMessage(UWM_SETIMAGE, 0, (LPARAM)&setImage); 
	}
	
	LRESULT OnSetImage(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
	{
		if (m_Image) delete m_Image, m_Image = 0;
		SETIMAGE* pSetImage = (SETIMAGE*)lParam;
		BITMAPINFOHEADER info;
		CopyMemory(&info, pSetImage->info, sizeof(BITMAPINFOHEADER));
		info.biHeight = - info.biHeight;
		m_Image = new Gdiplus::Bitmap((const BITMAPINFO*)&info, pSetImage->bits);
		Invalidate();
		return S_OK;
	}
private:
	Gdiplus::Bitmap*	m_Image;
};
