#pragma once

#ifdef	SIMAGE_EXPORTS
#define SIMAGE_API			__declspec(dllexport)
#else
#define SIMAGE_API			__declspec(dllimport)
#endif

#ifndef SINLINE
#ifdef _MSC_VER
  #if (_MSC_VER >= 1200)
  #define SINLINE __forceinline
  #else
  #define SINLINE __inline
  #endif
#else
  #ifdef __cplusplus
  #define SINLINE inline
  #else
  #define SINLINE
  #endif
#endif
#endif

#include "SEffect.h"
#include "STransition.h"
#include "SImageChannel.h"
#include "SImage.h"

#include "SDPicture.h"
#include "SDProject.h"

extern "C" SIMAGE_API DWORD			SInitEffectLibrary(LPCWSTR);
extern "C" SIMAGE_API DWORD			SGetEffectCount();
extern "C" SIMAGE_API LPCWSTR		SGetEffectName(DWORD /*dwID*/);
extern "C" SIMAGE_API LPCWSTR		SGetEffectDescription(DWORD /*dwID*/);
extern "C" SIMAGE_API LPCWSTR		SGetEffectPlugInFileName(DWORD /*dwID*/);
extern "C" SIMAGE_API BOOL			SGetEffectThumbnail(DWORD /*dwID*/, DWORD /*dwFlag*/, BITMAPINFOHEADER*, LONG* /*bits*/, LONG* /*size*/);
extern "C" SIMAGE_API HEFFECT		SCreateEffect(DWORD /*dwID*/, LPARAM lParam);
extern "C" SIMAGE_API void			SCloseEffect(HEFFECT&);

extern "C" SIMAGE_API DWORD			SInitTransitionLibrary(LPCWSTR);
extern "C" SIMAGE_API DWORD			SGetTransitionCount();
extern "C" SIMAGE_API LPCWSTR		SGetTransitionName(DWORD /*dwID*/);
extern "C" SIMAGE_API LPCWSTR		SGetTransitionDescription(DWORD /*dwID*/);
extern "C" SIMAGE_API LPCWSTR		SGetTransitionPlugInFileName(DWORD /*dwID*/);
extern "C" SIMAGE_API BOOL			SGetTransitionThumbnail(DWORD /*dwID*/, DWORD /*dwFlag*/, BITMAPINFOHEADER*, LONG* /*bits*/, LONG* /*size*/);
extern "C" SIMAGE_API HTRANSITION	SCreateTransition(DWORD /*dwID*/, LPARAM lParam);
extern "C" SIMAGE_API void			SCloseTransition(HTRANSITION&);