#include "StdAfx.h"
#include "Player.h"
#include <mmsystem.h>
#pragma comment(lib, "Winmm.lib")

CSDPlayer::CSDPlayer(void)
	: m_hThread(0)
	, m_Cmd(CMD_NONE)
	, m_WaittingFlag(0)
	, m_ProgressFunc(0)
	, m_Duration(0)
	, m_Pos(0)
	, m_Transition(0)
	, m_EffectType(EFFECT_NONE)
	, m_CmdWaitintFor(0)
	, m_Percent(0)
	, m_Even(1)
	, m_ImageA(0)
	, m_ImageB(0)
	, m_ImageC(0)
{
	m_PerformanceSampleRate = 0;
	m_FrameRate = 100;
	m_TimeLast = m_TimeEcllapsed = 0;
	// Use QueryPerformanceFrequency to get the frequency of the counter
	// The variable is the current performance-counter frequency, in counts per second. 
	// If the installed hardware does not support a high-resolution performance counter, this parameter can be zero
	LARGE_INTEGER TicksPerSec;
 	QueryPerformanceFrequency(&TicksPerSec);
	m_PerformanceFrequency = static_cast<double>(TicksPerSec.QuadPart);	// get time frequency

	SetFrameRate(500);

	m_CmdEvent = ::CreateEvent(NULL, FALSE, FALSE, NULL);
	m_CmdWaitintFor = CreateEvent(NULL, FALSE, FALSE, NULL);
}

CSDPlayer::~CSDPlayer(void)
{
	if (m_CmdEvent) CloseHandle(m_CmdEvent), m_CmdEvent = 0;
	if (m_CmdWaitintFor) CloseHandle(m_CmdWaitintFor), m_CmdWaitintFor = 0;
}

void CSDPlayer::Exit()
{
	Stop();

#pragma warning( push )
	// C4312: 'type cast' : conversion from 'LONG' to 'PVOID' of greater size
    //
    // This code works correctly on 32-bit and 64-bit systems.
#pragma warning( disable : 4312 )
	HANDLE hThread = (HANDLE)InterlockedExchangePointer(&m_hThread, 0);
#pragma warning( pop )

    if (hThread) {
		WaitForSingleObject(hThread, INFINITE);
		CloseHandle(hThread);
	}
}

void CSDPlayer::Init(void)
{
	m_TimeEcllapsed = 0;
	
	// start the thread
	CAutoLock Locker(&m_AccessLock);
	m_Cmd = CMD_PAUSE;

	DWORD threadid = 0;
	m_hThread = ::CreateThread(NULL, 0, ThreadProc, this, 0, &threadid);
}

void CSDPlayer::SetCommand(CSDPlayer::Command Cmd, LPARAM lParam)
{
	{
		CAutoLock lock(&m_AccessLock);
		ResetEvent(m_CmdWaitintFor);
		m_Cmd = Cmd;
		m_Param = lParam;
		if (m_WaittingFlag) 
		{
			SetEvent(m_CmdEvent);
		}
	}	
	
	if (m_CmdWaitintFor) {
		for(;;) {
			while(MsgWaitForMultipleObjects(1, &m_CmdWaitintFor, FALSE, INFINITE, QS_ALLINPUT) != WAIT_OBJECT_0) {
				MSG Message;
				while (PeekMessage(&Message, NULL, 0, 0, TRUE)) {
					TranslateMessage(&Message);
					DispatchMessage(&Message);
				}
			}
			break;
		}
	}
}

void CSDPlayer::SetPercent(DWORD dwPercent)
{
	{
		CAutoLock lock(&m_AccessLock);
		ResetEvent(m_CmdWaitintFor);
		m_Cmd = CMD_SETPERCENT;
		m_Param = dwPercent;
		if (m_WaittingFlag) 
		{
			SetEvent(m_CmdEvent);
		}
	}	
	if (m_CmdWaitintFor) {
		::WaitForSingleObject(m_CmdWaitintFor, INFINITE);
	}
}

void CSDPlayer::SetTransition(ISlideTransition* pEffect)
{
	SetCommand(CMD_SETTRANSITION, (LPARAM)pEffect);
}

DWORD CSDPlayer::Loop(void)
{
	LONG Waitting = 0;
	do {
		{
			CAutoLock lock(&m_AccessLock);
			Waitting = m_WaittingFlag;
		}

		if (Waitting) {
			::WaitForSingleObject(m_CmdEvent, INFINITE);
			CAutoLock lock(&m_AccessLock);
			m_WaittingFlag--;
		}

		{
			CAutoLock lock(&m_AccessLock);
			if (m_Cmd == CMD_STOP || m_Cmd == CMD_EXIT) {
				m_TimeEcllapsed = 0;
				
				if (m_CmdWaitintFor) 
					SetEvent(m_CmdWaitintFor);
				break;
			}
			else if (m_Cmd == CMD_PAUSE) {
				Sleep(20);
				m_WaittingFlag++;
				ResetEvent(m_CmdEvent);

				//m_TimeLast = timeGetTime();
				if (m_CmdWaitintFor) 
					SetEvent(m_CmdWaitintFor);

				continue;
			}
			else if (m_Cmd == CMD_RUN)
			{
				if (m_Percent >= 100) {
					m_Percent = 0;
					
				}

				m_Even = 1 - m_Even;
				m_TimeEcllapsed = 0;
				m_TimeLast = timeGetTime();
				QueryPerformanceCounter(&m_PerformanceLast);
				m_Cmd = CMD_NONE;
				
				if (m_CmdWaitintFor) 
					SetEvent(m_CmdWaitintFor);
			}
			else if (m_Cmd == CMD_SETPERCENT)
			{
				m_Percent = m_Param;
				m_Transition->DoEffect(m_ImageC, m_ImageA, m_ImageB, m_Percent, 0);

				if (m_ProgressFunc) 
				{
					m_ProgressFunc(m_Percent, TRUE);
				}

				if (m_CmdWaitintFor) 
					SetEvent(m_CmdWaitintFor);			

				continue;
			}
			else if (m_Cmd == CMD_SETTRANSITION)
			{
				m_Transition = (ISlideTransition*)m_Param;
				if (m_Transition) {
					m_EffectType = EFFECT_TRANSITION;
				}

				m_Percent = 0;
				m_Cmd = CMD_PAUSE;
				m_WaittingFlag++;
				ResetEvent(m_CmdEvent);

				if (m_CmdWaitintFor) 
					SetEvent(m_CmdWaitintFor);

				continue;
			}
		}
		if (m_Cmd == CMD_NONE) {
			if (S_OK != DoRender())
				break;
		}
	} while (1);

    return 0;
}

DWORD CSDPlayer::ThreadProc(LPVOID lParam) 
{
	CSDPlayer* Impl = (CSDPlayer*)lParam;
	return Impl->Loop();
}

HRESULT CSDPlayer::DoRender(void) 
{
	// all paths release the sample
	LARGE_INTEGER CurTime;
	QueryPerformanceCounter(&CurTime);

	double ElapsedCount = (static_cast<double>(CurTime.QuadPart - m_PerformanceLast.QuadPart));
	HRESULT hr = S_OK;

	if (ElapsedCount > m_PerformanceSampleRate) {
		DWORD dwTick = timeGetTime();
		m_TimeEcllapsed += (dwTick - m_TimeLast);
		m_TimeLast = dwTick;
		
		if (m_Percent >= 100) {
			m_Percent = 100;
			m_Cmd = CMD_PAUSE;
		}
		ISlideImage* pImageA = m_ImageA;
		ISlideImage* pImageB = m_ImageB;

		if (m_Even == 1) {
			pImageA = m_ImageB;
			pImageB = m_ImageA;
		}
        
		if (m_EffectType == EFFECT_TRANSITION && m_Transition != 0) {
			m_Transition->DoEffect(m_ImageC, pImageA, pImageB, m_Percent, 0);
		}
		
		m_PerformanceLast = CurTime;
		if (m_ProgressFunc) {
			m_ProgressFunc(m_Percent, FALSE);
		}
		m_Percent++;
	}
	return S_OK;
}

void CSDPlayer::SetFrameRate(double FrameRate)
{
	m_FrameRate = FrameRate;
	// the sample rate is duration between two frame
	m_PerformanceSampleRate = m_PerformanceFrequency / (m_FrameRate);
	static WCHAR Trace[256];
	swprintf(Trace, L"Frame rate %.3f, per second is %.3f unit, per frame is %.3f unit\n", m_FrameRate
		, m_PerformanceFrequency, m_PerformanceSampleRate);
	ATLTRACE(Trace);
}

void CSDPlayer::LimitThreadAffinityToCurrentProc()
{
	HANDLE hCurrentProcess = GetCurrentProcess();

	// Get the processor affinity mask for this process
	DWORD_PTR dwProcessAffinityMask = 0;
	DWORD_PTR dwSystemAffinityMask = 0;

	if (GetProcessAffinityMask(hCurrentProcess, 
		&dwProcessAffinityMask, &dwSystemAffinityMask ) != 0 && dwProcessAffinityMask)
	{
		// Find the lowest processor that our process is allows to run against
		DWORD_PTR dwAffinityMask = (dwProcessAffinityMask & ((~dwProcessAffinityMask) + 1));
		
		// Set this as the processor that our thread must always run against
		// This must be a subset of the process affinity mask
		HANDLE hCurrentThread = GetCurrentThread();
		if (INVALID_HANDLE_VALUE != hCurrentThread) {
			SetThreadAffinityMask(hCurrentThread, dwAffinityMask);
			CloseHandle(hCurrentThread);
		}
	}
    
	CloseHandle(hCurrentProcess);
}