//------------------------------------------------------------------------------
// File: SlideshowSourceFilter.h
//
// Desc: SlideshowSource Filter. You can push memory into it as a souce filter 
//
// Copyright (c) Bruce Lu.  All rights reserved.
//------------------------------------------------------------------------------

#pragma once

// {FD569957-B5E0-4bd9-8A5C-507850CEE22B}
DEFINE_GUID(CLSID_SlideshowSource,
0xfd569957, 0xb5e0, 0x4bd9, 0x8a, 0x5c, 0x50, 0x78, 0x50, 0xce, 0xe2, 0x2b);

// {D3A2DBD2-FE5E-46b4-999A-CB0355F404BD}
DEFINE_GUID(IID_ISlideshowSource,
0xd3a2dbd2, 0xfe5e, 0x46b4, 0x99, 0x9a, 0xcb, 0x3, 0x55, 0xf4, 0x4, 0xbd);

// {38858B3B-2D63-4113-8FDD-4F4E67296D30}
DEFINE_GUID(IID_ISlideshowCallback,
0x38858b3b, 0x2d63, 0x4113, 0x8f, 0xdd, 0x4f, 0x4e, 0x67, 0x29, 0x6d, 0x30);

// {3AE83239-AD91-4338-8D9C-3BB28C53D1DA}
DEFINE_GUID(CLSID_SlideshowSourcePropertyPage,
0x3ae83239, 0xad91, 0x4338, 0x8d, 0x9c, 0x3b, 0xb2, 0x8c, 0x53, 0xd1, 0xda);

DECLARE_INTERFACE_(ISlideshowCallback, IUnknown)
{
	STDMETHOD(OnSlideshowProcessing)(LONGLONG, LONGLONG, LONG*)			PURE;
};

DECLARE_INTERFACE_(ISlideshowSource, IUnknown)
{
	STDMETHOD(SetTransitionDir)		(BSTR FileName)						PURE;
	STDMETHOD(LoadProject)			(BSTR FileName)						PURE;
	STDMETHOD(GetOutputSize)		(LONG* lWidth, LONG* lHeight)		PURE;
	STDMETHOD(SetCallback)			(ISlideshowCallback*)				PURE;
};