#pragma once

// Eliminate spurious "statement has no effect" warnings.
#pragma warning(disable: 4705)

// Wrapper for whatever critical section we have
class CSmartCritSec 
{
public:
    
    CRITICAL_SECTION m_CritSec;

public:
    CSmartCritSec() 
	{
        InitializeCriticalSection(&m_CritSec);
    };

	~CSmartCritSec() 
	{
        DeleteCriticalSection(&m_CritSec);
    };

    void Lock() 
	{
        EnterCriticalSection(&m_CritSec);
    };

    void Unlock() 
	{
        LeaveCriticalSection(&m_CritSec);
    };
};

// locks a critical section, and unlocks it automatically when the lock goes out of scope
class CSmartLock 
{
protected:
    CSmartCritSec* m_CritSec;

public:
	CSmartLock(CSmartCritSec* pCrit) : m_CritSec(pCrit)
    {
        m_CritSec->Lock();
    };

    ~CSmartLock() 
	{
        m_CritSec->Unlock();
    };
};