#pragma once

typedef DWORD (WINAPI *PONPROGRESS)(LONGLONG dwPercent, BOOL bCallFromGUI);

class CEffectPlayer
{
public:
	class CCritSec 
	{
	public:
		CRITICAL_SECTION m_CritSec;

		CCritSec() 
		{
			InitializeCriticalSection(&m_CritSec);
		};
		
		virtual ~CCritSec() 
		{
			DeleteCriticalSection(&m_CritSec);
		};
		
		void Lock() 
		{
			EnterCriticalSection(&m_CritSec);
		};

		void Unlock() 
		{
			LeaveCriticalSection(&m_CritSec);
		};
	};

	class CAutoLock 
	{
	protected:
		CCritSec * m_pLock;
	
	public:
		CAutoLock(CCritSec * plock)
		{
			m_pLock = plock;
			m_pLock->Lock();
		};
		
		~CAutoLock() 
		{
			m_pLock->Unlock();
		};
	};

	
	enum Command 
	{
		  CMD_PAUSE
		, CMD_RUN
		, CMD_STOP
		, CMD_EXIT
		, CMD_SETPERCENT
		, CMD_SETEFFECT
		, CMD_SETTRANSITION
		, CMD_NONE
	};

	enum
	{
		EFFECT_NONE,
		EFFECT_EFFECT,
		EFFECT_TRANSITION,
	};

	CEffectPlayer(void);
	virtual ~CEffectPlayer(void);
	
	void	Init();
	void	Exit();
	void	SetEffect(HEFFECT);
	void	SetTransition(HTRANSITION);
	void	OnProgress(DWORD dwProgress);
	void	Play()					{ SetCommand(CMD_RUN);		}		// Play 
	void	Pause()					{ SetCommand(CMD_PAUSE);	}		// Pause 
	void	Stop()					{ SetCommand(CMD_STOP);		}		// Stop
	void	SetPercent(DWORD dwPercent);

	void	Seek(DWORD dwPos);
	void	SetProgressFunc(PONPROGRESS pFunc) { m_ProgressFunc = pFunc; }
	
protected:
	void	SetCommand(Command, LPARAM lParam = 0);
	virtual HRESULT DoRender(void);					// the loop executed whilst running
	    
	DWORD	Loop();									// thread loop function
	static DWORD WINAPI	ThreadProc(LPVOID);			// threas static function
	void				LimitThreadAffinityToCurrentProc();
	void				SetFrameRate(double FrameRate);

private:
	LPARAM				m_Param;
	LPARAM				m_Duration;
	LPARAM				m_Pos;
	HEFFECT				m_Effect;
	HTRANSITION			m_Transition;
	CCritSec			m_AccessLock;
	Command				m_Cmd;
	LONG				m_WaittingFlag;
	HANDLE				m_hThread;
	HANDLE				m_CmdEvent;
	HANDLE				m_CmdWaitintFor;
	LARGE_INTEGER		m_PerformanceLast;
	double				m_PerformanceSampleRate;
	double				m_PerformanceFrequency;
	double				m_FrameRate;
	DWORD				m_TimeLast;
	DWORD				m_TimeEcllapsed;
	PONPROGRESS			m_ProgressFunc;
	DWORD				m_EffectType;
	LONGLONG			m_Percent;
	
	DWORD				m_RenderTime;
	DWORD				m_RenderFrameCount;
	float				m_Fps;
	
	int					m_Even;

public:
	CSImage*			m_ImageA;		// input 0
	CSImage*			m_ImageB;		// input 1
	CSImage*			m_ImageC;		// output
	BITMAPINFOHEADER*	m_BitmapInfo;
};
