// DemoSDDlg.h : header file
//

#pragma once
#include "afxwin.h"
#include "Player.h"

// CDemoSDDlg dialog
class CDemoSDDlg : public CDialog
{
// Construction
public:
	CDemoSDDlg(CWnd* pParent = NULL);	// standard constructor
	DWORD	DoProgress(LONGLONG dwPercent, BOOL bCallFromGUI);
	static DWORD WINAPI	OnProgress(LONGLONG dwPercent, BOOL bCallFromGUI);

// Dialog Data
	enum { IDD = IDD_DEMOSD_DIALOG };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support


// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	DECLARE_MESSAGE_MAP()

private:
	ISlideFactory*		m_SDFactory;
	ISlideImage*		m_ImageA;
	ISlideImage*		m_ImageB;
	ISlideImage*		m_ImageC;
	ISlideTransition*	m_Transition;
	CListBox			m_CtrlTransitions;
	CSDPlayer			m_Player;
	static CDemoSDDlg*	m_Impl;
	BITMAPINFOHEADER	m_BitmapInfo;	
	BITMAPINFOHEADER	m_Info;
	BYTE*				m_Bits;
private:
	BOOL				Init();
	void				LoadTransitions();
	
	inline void SetImageToDlg(LPBYTE bits)
	{
		HDC hDC = ::GetDC(m_hWnd);
		SetDIBitsToDevice(hDC, 4, 4, m_BitmapInfo.biWidth, m_BitmapInfo.biHeight, 0, 0, 0, m_BitmapInfo.biHeight, 
			bits, (const BITMAPINFO*)&m_Info, DIB_RGB_COLORS);
		::ReleaseDC(m_hWnd, hDC);
	}

public:
	afx_msg void OnDestroy();
	afx_msg void OnBnClickedBtnPlay();
	afx_msg void OnBnClickedBtnPause();
	afx_msg void OnLbnSelchangeListEffects();
};
