#pragma once

#include <objidl.h>

class SIMAGE_API CSImageChannel
{
public:
	CSImageChannel(void);
	CSImageChannel(long /*width*/, long /*height*/);
	CSImageChannel(const CSImageChannel&);
	virtual ~CSImageChannel(void);

	inline void Release();
	inline long IsReady() const { return m_Ready; }
	inline long	Width() const { return m_Width; }
	inline long	Height() const { return m_Height; }
	inline long	Pitch() const { return m_Pitch; }
	inline		LPBYTE GetBits() { return m_Bits; }
	inline		LPBYTE GetConstBits() const { return m_Bits; }
	long		Save(LPCWSTR);
	void		SetSize(long width, long height);
	void		Fill(BYTE);
	
protected:
	long		m_Ready;
	long		m_Width;
	long		m_Height;
	long		m_Pitch;
	LPBYTE		m_Bits;
};
