#pragma once

#pragma warning(disable:4251)

#include <vector>
#include <string>

class SIMAGE_API ZipFile
{
public:
	ZipFile();
	ZipFile(LPCWSTR);
	virtual ~ZipFile(void);

	bool		Open(LPCWSTR, BOOL bGenerateFileList = FALSE);
	bool		OpenA(const char*, BOOL bGenerateFileList = FALSE);
	void		Close();

	LPVOID		Decompress2HeapW(LPCWSTR, HANDLE*, LONGLONG*);
	LPVOID		Decompress2HeapA(LPCSTR, HANDLE*, LONGLONG*);

	bool		Decompress2Stream(LPCWSTR, IStream**);
	HGLOBAL		Decompress2Global(LPCWSTR);
	bool		Decompress2StreamA(LPCSTR, IStream**);
	HGLOBAL		Decompress2GlobalA(LPCSTR);
	bool		IsOpened() { if (m_Zip == 0) return false; return true; }
	int			GetFilesCount() { return static_cast<int>(m_Files.size()); }
	const char* GetFileName(int i) { return m_Files[i]; }

private:
	int			GenerateFileList();
	
protected:
	LONGLONG					m_Zip;
	std::vector<char*>			m_Files;
};
