#pragma once

class CSImage;

class SIMAGE_API CSTransition
{
public:
	CSTransition(void) : m_EffectID(-1)
	{
	}

	virtual ~CSTransition(void)
	{
	}

	virtual		LRESULT DoEffect(CSImage* pImageD, CSImage* pImageA, CSImage* pImageB, LONGLONG llPercent = 0, LONGLONG llFlag = 0) = 0;
	virtual		LRESULT	OnCreate(LONGLONG llData) { m_EffectUserData = llData; return S_OK; }
	virtual		LRESULT OnDestroy() { return S_OK; }
	DWORD		GetID() { return m_EffectID; }
	void		SetID(DWORD dwID) { m_EffectID = dwID; }
	LONGLONG	GetUserData() { return m_EffectUserData; }
	
	LRESULT	GetAttributeDefault(LPCWSTR, LONGLONG& llDefault) 
	{ 
		llDefault = 0;
		return S_OK; 
	}

	LRESULT	GetAttribute(LPCWSTR, LONGLONG& llGetted)
	{
		llGetted = 0;
		return S_OK; 
	}

	LRESULT SetAttribute(LPCWSTR, LONGLONG)
	{
		return S_OK;
	}

	LRESULT	GetAttributeRangle(LPCWSTR, LONGLONG& llMin, LONGLONG& llMax)
	{
		llMin = llMax = 0;
		return S_OK;
	}

protected:
	DWORD		m_EffectID;
	LONGLONG	m_EffectUserData;
};

typedef CSTransition* HTRANSITION;
