// VCamFilterTestDlg.cpp : implementation file
//

#include "stdafx.h"
#include "VCamFilterTest.h"
#include "VCamFilterTestDlg.h"
#include "VCamSDKImpl.h"
#include "VCamTestDlg.h"
#include <GdiPlus.h>

#pragma comment(lib, "gdiplus")

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CVCamFilterTestDlg dialog

BEGIN_DHTML_EVENT_MAP(CVCamFilterTestDlg)
	DHTML_EVENT_ONCLICK(_T("ButtonOK"), OnButtonOK)
	DHTML_EVENT_ONCLICK(_T("ButtonPlayFile"), OnButtonPlayFile)
	DHTML_EVENT_ONCLICK(_T("ButtonSeek"), OnButtonSeek)
	DHTML_EVENT_ONCLICK(_T("ButtonPlayDevice"), OnButtonPlayDevice)
	DHTML_EVENT_ONCLICK(_T("ButtonScreenCapture"), OnButtonScreenCapture)
	DHTML_EVENT_ONCLICK(_T("ButtonScreenCaptureFixed"), OnButtonScreenCaptureFixed)
	DHTML_EVENT_ONCLICK(_T("ButtonPlayBuffer"), OnButtonPlayBuffer)
	DHTML_EVENT_ONCLICK(_T("ButtonOverlay"), OnButtonOverlay)
	DHTML_EVENT_ONCLICK(_T("ButtonStop"), OnButtonStop)
	DHTML_EVENT_ONCLICK(_T("ButtonConfig"), OnButtonConfig)
END_DHTML_EVENT_MAP()


CVCamFilterTestDlg::CVCamFilterTestDlg(CWnd* pParent /*=NULL*/)
	: CDHtmlDialog(CVCamFilterTestDlg::IDD, CVCamFilterTestDlg::IDH, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CVCamFilterTestDlg::DoDataExchange(CDataExchange* pDX)
{
	CDHtmlDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CVCamFilterTestDlg, CDHtmlDialog)
	//}}AFX_MSG_MAP
	ON_WM_CLOSE()
	ON_WM_TIMER()
END_MESSAGE_MAP()


// CVCamFilterTestDlg message handlers

BOOL CVCamFilterTestDlg::OnInitDialog()
{
	CDHtmlDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here
	m_pIVCamSource = new CVCamSDKImpl;
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CVCamFilterTestDlg::OnClose()
{
	// TODO: Add your message handler code here and/or call default
	delete m_pIVCamSource;
	m_pIVCamSource = NULL;
	CDHtmlDialog::OnClose();
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CVCamFilterTestDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDHtmlDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CVCamFilterTestDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

HRESULT CVCamFilterTestDlg::OnButtonOK(IHTMLElement* /*pElement*/)
{
	SendMessage(WM_CLOSE);
	return S_OK;
}

HRESULT CVCamFilterTestDlg::OnButtonPlayFile(IHTMLElement* /*pElement*/)
{
	OnButtonStop(NULL);

	CFileDialog dlg(TRUE, NULL, NULL, OFN_FILEMUSTEXIST | OFN_HIDEREADONLY, _T("Video files (*.*)|*.*||"));
	if (IDOK == dlg.DoModal()) {
		HRESULT hr = m_pIVCamSource->PlayVideoFile(dlg.GetPathName());
		SetTimer(1, 1000, NULL);
	}	
	return S_OK;
}

HRESULT CVCamFilterTestDlg::OnButtonSeek(IHTMLElement* /*pElement*/)
{
	m_pIVCamSource->SetCurrentVideoPosition(30 * 1000);
	return S_OK;
}

HRESULT CVCamFilterTestDlg::OnButtonPlayDevice(IHTMLElement* /*pElement*/)
{
	OnButtonStop(NULL);

	int no = 0;

	if (IDYES == MessageBox(_T("Choose [Yes] if VCam is your first Video Capture Device,\n\r")\
		_T("Choose [No] if not.\n\n\rNote: You must have one Video Capture Device to use this feature."), 
		_T("Question"), MB_ICONQUESTION | MB_YESNO)) {
		no = 1;
	}

	HRESULT hr = m_pIVCamSource->PlayVideoDevice(no); // if #1 is e2eCam, change it to #0, or #2...

	SetElementText(_T("test"), _bstr_t(L"Playing video device..."));
	return S_OK;
}

HRESULT CVCamFilterTestDlg::OnButtonScreenCapture(IHTMLElement* /*pElement*/)
{
	OnButtonStop(NULL);

	m_pIVCamSource->CaptureScreen();

	SetElementText(_T("test"), _bstr_t(L"Capturing screen ..."));
	return S_OK;
}

HRESULT CVCamFilterTestDlg::OnButtonScreenCaptureFixed(IHTMLElement* /*pElement*/)
{
	OnButtonStop(NULL);

	RECT rc = {100, 100, 420, 340};
	m_pIVCamSource->CaptureScreen(rc);

	SetElementText(_T("test"), _bstr_t(L"Capturing screen [100, 100] 320 x 240..."));
	return S_OK;
}

HRESULT CVCamFilterTestDlg::OnButtonPlayBuffer(IHTMLElement* /*pElement*/)
{
	OnButtonStop(NULL);

	LPBYTE buffer = new BYTE[320*240*3];
	srand( (unsigned)time( NULL ) );
	for (int i=0; i<320*240*3; i++) {
		buffer[i] = rand()%255;
	}
	m_pIVCamSource->PlayBuffer(buffer, 320, 240);
	delete buffer;

	SetElementText(_T("test"), _bstr_t(L"Sent one buffer"));

	return S_OK;
}

HRESULT CVCamFilterTestDlg::OnButtonOverlay(IHTMLElement* /*pElement*/)
{	
	using namespace Gdiplus;
	WCHAR strPath[MAX_PATH] = {0};
	GetModuleFileNameW(AfxGetApp()->m_hInstance, strPath, MAX_PATH);
	PathRemoveFileSpecW(strPath);
	StrCatW(strPath, L"\\star.png");
	Bitmap* png = Bitmap::FromFile(strPath); // a transparent png file
	if (png && png->GetWidth() > 0) {
		Rect rc(0, 0, png->GetWidth(), png->GetHeight());
		BitmapData bd;
		png->LockBits(&rc, ImageLockModeRead, PixelFormat32bppARGB, &bd);
		PBYTE img = (PBYTE) bd.Scan0;

		// RGBA -> ARGB
		BYTE a,r,g,b;
		for (int i=0; i<bd.Height; i++) {
			PBYTE hd = img+i*bd.Stride;
			for (int j=0; j<bd.Width; j++) {
				r = hd[j*4+0];
				g = hd[j*4+1];
				b = hd[j*4+2];
				a = hd[j*4+3];

				hd[j*4+0] = a;
				hd[j*4+1] = r;
				hd[j*4+2] = g;
				hd[j*4+3] = b;
			}
		}
		m_pIVCamSource->AddOverlay((BYTE*)bd.Scan0, png->GetWidth(), png->GetHeight(), 280, 10, 0);
		png->UnlockBits(&bd);
	}
	// m_pIVCamSource->AddOverlay(NULL, 0, 0, 0, 0, 0); // remove it

	m_pIVCamSource->AddText(_bstr_t(_T("This is text one")), _bstr_t(_T("Comic Sans MS")), -20, 0, RGB(255, 0, 0), RGB(0, 255, 0), 75, 80, 1, 0);
	// m_pIVCamSource->AddText(NULL, NULL, 0, 0, 0, 0, 0, 0); // remove it
	m_pIVCamSource->AddText(_bstr_t(_T("This is text two")), _bstr_t(_T("Comic Sans MS")), -16, 0, RGB(0, 0, 255), RGB(255, 255, 0), 75, 110, 2, 1);	
	m_pIVCamSource->AddText(_bstr_t(_T("This is text three")), _bstr_t(_T("Comic Sans MS")), -16, 0, RGB(0, 0, 255), RGB(255, 255, 0), 75, 140, 0, 2);

	KillTimer(2);
	SetTimer(2, 40, NULL); // scroll text...

	return S_OK;
}

HRESULT CVCamFilterTestDlg::OnButtonStop(IHTMLElement* /*pElement*/)
{
	KillTimer(1);
	SetElementText(_T("test"), _bstr_t(L"Stopped!"));

	m_pIVCamSource->StopPlay();
	m_pIVCamSource->StopCapture();
	return S_OK;
}

HRESULT CVCamFilterTestDlg::OnButtonConfig(IHTMLElement* /*pElement*/)
{
	m_pIVCamSource->SetProp(0, 640); // 640 x 480
	m_pIVCamSource->SetProp(1, 480);
	m_pIVCamSource->SetProp(3, 1000000);
	SetElementHtml(_T("test"), _bstr_t(L"VCam's default frame rate is set to 10, " \
		L"and video size is changed to 640 x 480. <br/>"));
	return S_OK;
}

void CVCamFilterTestDlg::OnTimer(UINT nIDEvent)
{
	if (nIDEvent == 1) {

		CString info;
		LONG pos = m_pIVCamSource->GetCurrentVideoPosition() / 1000;
		LONG dur = m_pIVCamSource->GetCurrentVideoDuration() / 1000;

		int nCurrentHours   = (int) (pos / ( 3600 ));
		int nCurrentMinutes = (int) (( pos / 60 ) - ( nCurrentHours * 60 ));
		int nCurrentSeconds = (int) (( pos ) - ( nCurrentMinutes * 60 ));

		int nDurationHours   = (int) (dur / ( 3600 ));
		int nDurationMinutes = (int) (( dur / 60 ) - ( nDurationHours * 60 ));
		int nDurationSeconds = (int) (( dur ) - ( nDurationMinutes * 60 ));

		info.Format(_T("Current video position: %2.2ld:%2.2ld:%2.2ld / %2.2ld:%2.2ld:%2.2ld"), 
			nCurrentHours, nCurrentMinutes, nCurrentSeconds, nDurationHours, nDurationMinutes, nDurationSeconds);
		SetElementText(_T("test"), _bstr_t(info));

		if (pos + 1 > dur && !m_pIVCamSource->IsPlaying()) {
			SetElementText(_T("test"), _bstr_t(L"Play finished!"));
			KillTimer(1);
		}
	} else {
		static int oltx = 320;
		m_pIVCamSource->AddText(_bstr_t(_T("This is text four, welcome to use VCam SDK...")), 
			_bstr_t(_T("Arial")), -14, 0, RGB(255, 255, 128), RGB(0, 128, 0), oltx, 220, 3, 3);
		oltx -= 1;
		if (oltx < -320) { oltx = 320; }
	}

	CDHtmlDialog::OnTimer(nIDEvent);
}
