﻿#include <atlbase.h>

// DirectShow
#include <strmif.h>
#pragma comment(lib, "strmiids.lib")

// VCam renderer guids
#include "VCamRenderer_i.c"

// VCam renderer interface
#import "VCamRenderer.tlb" no_namespace, raw_interfaces_only exclude("UINT_PTR") 

int main()
{
	HRESULT hr = ::CoInitialize(nullptr);

	{
		// Create VCam renderer filter
		CComPtr<IBaseFilter> pVCamRenderer;
		if (FAILED(hr = CoCreateInstance(CLSID_VCamRenderer, NULL, CLSCTX_INPROC, IID_IBaseFilter, reinterpret_cast<void**>(&pVCamRenderer)))) {
			MessageBox(NULL, _T("VCamRenderer filter is not registered!"), _T("Error"), MB_OK | MB_ICONERROR);
			return -1;
		}

		// Get the IVCamRenderer interface from VCam Renderer filter
		CComPtr<IVCamRenderer> pIVCam;
		if (FAILED(hr = pVCamRenderer->QueryInterface(&pIVCam))) {
			MessageBox(NULL, _T("VCam Driver is not installed!"), _T("Error"), MB_OK | MB_ICONERROR);
			return -2;
		}

		// Create a RGB24 buffer with color filled and send it to VCam
		int imgWidth = 640, imgHeight = 480;
		int imgStride = imgWidth * 3;
		PBYTE pImgBuffer = new BYTE[imgStride * imgHeight];
		for (int j = 0; j < imgHeight; j++) {
			PBYTE p = pImgBuffer + imgStride * j;
			for (int i = 0; i < imgWidth; i++) {
				*p++ = abs(j - 0xFF) % 0xFF;
				*p++ = 0;
				*p++ = 0;
			}
		}
		pIVCam->SendFrame(pImgBuffer, imgWidth, -imgHeight, imgStride);
		delete[] pImgBuffer;
	}

	::CoUninitialize();

	return 0;
}