#region license

/*
VCamRenderer - Provide access to VCamRenderer interfaces via .NET
Copyright(C) 2017 e2esoft.
*/

#endregion

using System;
using System.Runtime.InteropServices;

namespace VCamRendererLib
{
    #region Interfaces
    
    [ComImport, System.Security.SuppressUnmanagedCodeSecurity,
    Guid("855DAEFD-6664-49C4-BBAA-813A9A41659E"),
    InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
    public interface IVCamRenderer
    {
        [PreserveSig]
        int SetCurrentDevice([In] int index);

        [PreserveSig]
        int SetOutputFormat([In] int width, [In] int height, [In] int fps, [In] int format, [In] int one_size_only);

        [PreserveSig]
        int GetOutputFormat([Out] out int width, [Out] out int height, [Out] out int fps, [Out] out int format, [Out] out int one_size_only);

        [PreserveSig]
        int SetFillMode([In] int mode);

        [PreserveSig]
        int GetFillMode([Out] out int mode);

        [PreserveSig]
        int SetMirror([In] int mirror);

        [PreserveSig]
        int SetFlip([In] int flip);

        [PreserveSig]
        int SetRotateRight([In] int rotate);

        [PreserveSig]
        int SendFrame([In] ref byte rgb24_pixels, [In] int width, [In] int height, [In] int stride);

        [PreserveSig]
        int SendFrame32([In] ref byte rgb32_pixels, [In] int width, [In] int height, [In] int stride);

        [PreserveSig]
        int SendFrame32A([In] ref byte argb32_pixels, [In] int width, [In] int height, [In] int stride);

        [PreserveSig]
        int SendFrameYUY2([In] ref byte yuy2_pixels, [In] int width, [In] int height, [In] int stride);

        [PreserveSig]
        int SendFrameNV12([In] ref byte nv12_pixels, [In] int width, [In] int height, [In] int stride);

        [PreserveSig]
        int SendFrameEx([In] object rgb24_array, [In] int width, [In] int height);

        [PreserveSig]
        int CaptureScreen([In] int x, [In] int y, [In] int width, [In] int height);

        [PreserveSig]
        int SetConnectionNotificationEvent([In] Int64 handle);

        [PreserveSig]
        int GetConnectedCount([Out] out int count);

        [PreserveSig]
        int IsOpened();

        [PreserveSig]
        int Snapshot([In, MarshalAs(UnmanagedType.LPWStr)] string name);

        [PreserveSig]
        int SetIdleFileName([In, MarshalAs(UnmanagedType.LPWStr)] string name);

        [PreserveSig]
        int SetFriendlyName([In, MarshalAs(UnmanagedType.LPWStr)] string name);
        
        [PreserveSig]
        int SetLicenseCode([In, MarshalAs(UnmanagedType.LPWStr)] string name);
    }

    #endregion
}
