﻿using System;
using System.Runtime.InteropServices;
using System.Windows.Forms;
using VSCSDKLib;

namespace VSCSDKTest
{
    public partial class MainForm : Form
    {
        private VSC _vsc;

        public MainForm()
        {
            InitializeComponent();
            _vsc = new VSC();
        }

        private void buttonOpen_Click(object sender, EventArgs e)
        {
            try
            {
                _vsc.OpenInterface();
            }
            catch(COMException ce)
            {
                if ((UInt32)ce.ErrorCode == 0x80004005)
                    MessageBox.Show("OpenInterface failed, the VSC driver is not installed?", 
                        "Error",
                        MessageBoxButtons.OK, MessageBoxIcon.Stop);
                return;
            }
        }

        private void buttonInstances_Click(object sender, EventArgs e)
        {
            MessageBox.Show("Current Instance count is " + _vsc.InstanceCount.ToString());
            if (_vsc.InstanceCount++ > 10)
                _vsc.InstanceCount = 1; // change instance count
        }

        private void buttonVolumeControl_Click(object sender, EventArgs e)
        {
            MessageBox.Show("Volume Control is " + (_vsc.VolumeControlEnabled ? "enabled" : "disabled"));
            _vsc.VolumeControlEnabled = !_vsc.VolumeControlEnabled; // change volume control
        }

        private void buttonLicense_Click(object sender, EventArgs e)
        {
            _vsc.SetLicenseCode("XXXX-XXXXX-XXXXX-XXXXX-XXXXX");
        }

        private void buttonClose_Click(object sender, EventArgs e)
        {
            _vsc.CloseInterface();
        }

        private void buttonRestart_Click(object sender, EventArgs e)
        {
            _vsc.CloseInterface(); // close it first, otherwise reboot PC is needed

            _vsc.RestartDriver();

            _vsc.OpenInterface();
        }
    }
}
